<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('2ba_data', function (Blueprint $table) {
            $table->id();
            $table->string('internalCode')->nullable();
            $table->string('productCode')->nullable();
            $table->string('gln')->nullable();
            $table->string('gtin')->nullable();
            $table->string('brandName')->nullable();
            $table->text('description')->nullable();
            $table->string('etimClass')->nullable();
            $table->json('etim')->nullable();
            $table->json('attachments')->nullable();
            $table->integer('is_synced')->default(0);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('2ba_data');
    }
};
