<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('2ba_data')) {
            Schema::table('2ba_data', function (Blueprint $table) {
                $table->boolean('is_media_synced')->default(false)->after('attachments');
                $table->index('is_media_synced', '2ba_data_is_media_synced_index');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('2ba_data')) {
            Schema::table('2ba_data', function (Blueprint $table) {
                $table->dropIndex('2ba_data_is_media_synced_index');
                $table->dropColumn('is_media_synced');
            });
        }
    }
};


