<?php

namespace Daylight\Connector2BA\Requests\Products;

use Daylight\Connector\Contracts\MapperInterface;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetProductsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected MapperInterface $mapper,
        protected readonly int $page = 1,
        protected readonly int $limit = 10,
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/api/v1/products';
    }

    protected function defaultQuery(): array
    {
        return [
            'page' => $this->page,
            'limit' => $this->limit,
        ];
    }

    public function createDtoFromResponse(Response $response): mixed
    {
        $json = $response->json();

        // Assuming 2BA returns products in a 'data' field
        $products = $json['data'] ?? $json;

        if (!is_array($products)) {
            return collect();
        }

        return collect($products)
            ->map(fn ($item) => $this->mapper->map($item));
    }
}

