<?php

require_once __DIR__ . '/vendor/autoload.php';

use Daylight\Connector2BA\Service\ETIMReader;

// Create a proper ETIM JSON structure for testing

$testData = [
    'CatalogueId' => '2BA-EXP-1299151160',
    'CatalogueName' => [
        [
            'Language' => 'nl-NL',
            'CatalogueName' => '2BA Export: HEG klantportaal 2025-09-10'
        ]
    ],
    'CatalogueVersion' => '1',
    'CatalogueType' => 'FULL',
    'GenerationDate' => '2025-09-10',
    'CatalogueValidityStart' => '2025-09-10',
    'Language' => [
        'nl-NL'
    ],
    'Supplier' => [
        [
            'SupplierName' => 'Horst Electro Grossier (HEG)',
            'SupplierIdGln' => '8714253038889',
            'Product' => [
                [
                    'ProductIdentification' => [
                        'ManufacturerIdGln' => '0042186000016',
                        'ManufacturerName' => 'Zircon',
                        'ManufacturerProductNumber' => '68720',
                        'ProductGtin' => [
                            '04218668721007'
                        ]
                    ],
                    'TradeItem' => [
                        [
                            'ItemIdentification' => [
                                'SupplierItemNumber' => '6028665004',
                                'ItemGtin' => [
                                    '04218668721007'
                                ],
                                'DiscountGroupId' => '60171'
                            ],
                            'ItemDetails' => [
                                'ItemStatus' => 'ACTIVE',
                                'StockItem' => true,
                                'ItemDescriptions' => [
                                    [
                                        'DescriptionLanguage' => 'nl-NL',
                                        'MinimalItemDescription' => 'ZIRCON L550C MULTIFUNCT. MUURSCANNER'
                                    ]
                                ]
                            ],
                            'ItemLogisticDetails' => [
                                []
                            ],
                            'Ordering' => [
                                'OrderUnit' => 'C62',
                                'MinimumOrderQuantity' => '1.000',
                                'OrderStepSize' => '1.000',
                                'UseUnit' => 'C62',
                                'UseUnitConversionFactor' => '1.000',
                                'SingleUseUnitQuantity' => '1.000'
                            ],
                            'Pricing' => [
                                [
                                    'PriceUnit' => 'C62',
                                    'PriceUnitFactor' => '1.000',
                                    'PriceQuantity' => '1.000',
                                    'PriceOnRequest' => false,
                                    'GrossListPrice' => '92.000',
                                    'Vat' => '21.00',
                                    'PriceValidityDate' => '2023-08-02'
                                ]
                            ],
                            'ItemCountrySpecificFields' => [
                                [
                                    'CSItemCharacteristicCode' => 'NL_012',
                                    'CSItemCharacteristicName' => [
                                        [
                                            'CSItemCharacteristicName' => 'Orderable indicator'
                                        ]
                                    ],
                                    'CSItemCharacteristicValueBoolean' => true
                                ],
                                [
                                    'CSItemCharacteristicCode' => 'NL_014',
                                    'CSItemCharacteristicName' => [
                                        [
                                            'CSItemCharacteristicName' => 'Fragile on package'
                                        ]
                                    ],
                                    'CSItemCharacteristicValueBoolean' => false
                                ],
                                [
                                    'CSItemCharacteristicCode' => 'NL_015',
                                    'CSItemCharacteristicName' => [
                                        [
                                            'CSItemCharacteristicName' => 'Best before date on package'
                                        ]
                                    ],
                                    'CSItemCharacteristicValueBoolean' => false
                                ],
                                [
                                    'CSItemCharacteristicCode' => 'NL_016-1',
                                    'CSItemCharacteristicName' => [
                                        [
                                            'CSItemCharacteristicName' => 'Cuttable indicator'
                                        ]
                                    ],
                                    'CSItemCharacteristicValueBoolean' => false
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ]
    ]
];

//$testData = [
//    'CatalogueId' => 'TEST-ETIM-123',
//    'CatalogueName' => [['Language' => 'nl-NL', 'CatalogueName' => 'Test ETIM Catalog']],
//    'CatalogueVersion' => '1',
//    'CatalogueType' => 'FULL',
//    'GenerationDate' => '2025-09-22',
//    'Language' => ['nl-NL'],
//    'Supplier' => [
//        [
//            'SupplierName' => 'Test Supplier 1',
//            'SupplierIdGln' => '1234567890123',
//            'Product' => [
//                [
//                    'ProductIdentification' => [
//                        'ManufacturerIdGln' => '0042186000016',
//                        'ManufacturerName' => 'Test Manufacturer',
//                        'ManufacturerProductNumber' => 'TEST-001',
//                        'ProductGtin' => ['04218668721001']
//                    ],
//                    'TradeItem' => [
//                        [
//                            'ItemIdentification' => [
//                                'SupplierItemNumber' => 'ITEM-001',
//                                'ItemGtin' => ['04218668721001'],
//                                'DiscountGroupId' => '60171'
//                            ],
//                            'ItemDetails' => [
//                                'ItemStatus' => 'ACTIVE',
//                                'StockItem' => true,
//                                'ItemDescriptions' => [
//                                    [
//                                        'DescriptionLanguage' => 'nl-NL',
//                                        'MinimalItemDescription' => 'Test Product 1 Description'
//                                    ]
//                                ]
//                            ],
//                            'Ordering' => [
//                                'OrderUnit' => 'C62',
//                                'MinimumOrderQuantity' => '1.000',
//                                'OrderStepSize' => '1.000'
//                            ],
//                            'Pricing' => [
//                                [
//                                    'PriceUnit' => 'C62',
//                                    'PriceQuantity' => '1.000',
//                                    'PriceOnRequest' => false,
//                                    'GrossListPrice' => '99.99',
//                                    'Vat' => '21.00'
//                                ]
//                            ]
//                        ],
//                        [
//                            'ItemIdentification' => [
//                                'SupplierItemNumber' => 'ITEM-002',
//                                'ItemGtin' => ['04218668721002'],
//                                'DiscountGroupId' => '60172'
//                            ],
//                            'ItemDetails' => [
//                                'ItemStatus' => 'ACTIVE',
//                                'StockItem' => true,
//                                'ItemDescriptions' => [
//                                    [
//                                        'DescriptionLanguage' => 'nl-NL',
//                                        'MinimalItemDescription' => 'Test Product 2 Description'
//                                    ]
//                                ]
//                            ],
//                            'Pricing' => [
//                                [
//                                    'GrossListPrice' => '149.99',
//                                    'Vat' => '21.00'
//                                ]
//                            ]
//                        ]
//                    ]
//                ]
//            ]
//        ],
//        [
//            'SupplierName' => 'Test Supplier 2',
//            'SupplierIdGln' => '9876543210987',
//            'Product' => [
//                [
//                    'ProductIdentification' => [
//                        'ManufacturerIdGln' => '0042186000017',
//                        'ManufacturerName' => 'Another Manufacturer',
//                        'ManufacturerProductNumber' => 'TEST-002',
//                        'ProductGtin' => ['04218668721003']
//                    ],
//                    'TradeItem' => [
//                        [
//                            'ItemIdentification' => [
//                                'SupplierItemNumber' => 'ITEM-003',
//                                'ItemGtin' => ['04218668721003']
//                            ],
//                            'ItemDetails' => [
//                                'ItemStatus' => 'ACTIVE',
//                                'StockItem' => false,
//                                'ItemDescriptions' => [
//                                    [
//                                        'DescriptionLanguage' => 'nl-NL',
//                                        'MinimalItemDescription' => 'Test Product 3 Description'
//                                    ]
//                                ]
//                            ],
//                            'Pricing' => [
//                                [
//                                    'GrossListPrice' => '199.99',
//                                    'Vat' => '21.00'
//                                ]
//                            ]
//                        ]
//                    ]
//                ]
//            ]
//        ]
//    ]
//];

// Create test directory and file
$testDir = __DIR__ . '/test_data';
if (!is_dir($testDir)) {
    mkdir($testDir, 0755, true);
}

$testFile = $testDir . '/ETIMxChangeExport.json';
file_put_contents($testFile, json_encode($testData, JSON_PRETTY_PRINT));

echo "Created test JSON file: $testFile\n";
echo "Test data contains " . count($testData) . " items\n\n";

// Test the ETIMReader
try {
    $reader = new ETIMReader($testDir, 'ETIMxChangeExport.json');

    echo "Testing ETIMReader with JsonParser streaming (batch size 2):\n";
    echo "===========================================================\n";

    $batchNumber = 1;
    $totalProcessed = 0;

    foreach ($reader->readFile(2) as $batch) {
        echo "Batch $batchNumber:\n";
        echo "  Items in batch: " . count($batch) . "\n";

        foreach ($batch as $index => $item) {
            echo "  Item " . ($index + 1) . ":\n";
            echo "    Supplier: " . ($item['SupplierName'] ?? 'N/A') . "\n";
            echo "    Supplier GLN: " . ($item['SupplierGLN'] ?? 'N/A') . "\n";
            echo "    Trade Item ID: " . ($item['TradeItemId'] ?? 'N/A') . "\n";
            echo "    GTIN: " . ($item['GTIN'] ?? 'N/A') . "\n";
            echo "    Description: " . ($item['Description'] ?? 'N/A') . "\n";
            echo "    Price: €" . ($item['GrossPriceInOrderUnit'] ?? 'N/A') . "\n";
            echo "    Status: " . ($item['StatusCode'] ?? 'N/A') . "\n";
            echo "    Source file: " . ($item['_source_file'] ?? 'N/A') . "\n";
            echo "    Item number: " . ($item['_item_number'] ?? 'N/A') . "\n";
            echo "\n";
        }

        $totalProcessed += count($batch);
        $batchNumber++;
    }

    echo "✅ Total items processed: $totalProcessed\n";
    echo "✅ JsonParser streaming worked correctly!\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

// Clean up test file
unlink($testFile);
rmdir($testDir);
echo "\nTest completed and cleaned up.\n";


