<?php

namespace Daylight\Connector2BA\Entities;

use Daylight\Connector\Entities\Product as BaseProduct;
use Spatie\LaravelData\Data;

class Product extends BaseProduct
{
    public function __construct(
        public string $id,
        public string $sku,
        public ?string $ean = null,
        public string $name,
        public ?string $shortDescription = null,
        public ?string $longDescription = null,
        public ?string $marketingText = null,
        public ?string $technicalDescription = null,
        public ?string $category = null,
        public ?string $brand = null,
        public ?string $model = null,
        public ?array $specifications = null,
        public ?array $features = null,
        public ?array $attributes = null,
        public ?array $media = null,
        public ?array $images = null,
        public ?array $documents = null,
        public ?array $videos = null,
        public ?string $color = null,
        public ?string $size = null,
        public ?string $material = null,
        public ?array $dimensions = null,
        public ?float $weight = null,
        public bool $active = true,
        public ?string $createdAt = null,
        public ?string $updatedAt = null,
    ) {
        //
    }

    public function canBePurchased(): bool
    {
        return $this->active;
    }

    public function hasMedia(): bool
    {
        return !empty($this->media) || !empty($this->images) || !empty($this->documents) || !empty($this->videos);
    }

    public function hasImages(): bool
    {
        return !empty($this->images);
    }

    public function hasDocuments(): bool
    {
        return !empty($this->documents);
    }

    public function hasVideos(): bool
    {
        return !empty($this->videos);
    }

    public function getMainImage(): ?string
    {
        if (empty($this->images)) {
            return null;
        }

        // Return first image or look for main/primary image
        foreach ($this->images as $image) {
            if (is_array($image) && ($image['is_main'] ?? false)) {
                return $image['url'] ?? null;
            }
        }

        // Return first image if no main image found
        return is_array($this->images[0]) ? $this->images[0]['url'] ?? null : $this->images[0] ?? null;
    }

    public function getSpecificationValue(string $key): ?string
    {
        return $this->specifications[$key] ?? null;
    }

    public function getAttributeValue(string $key): ?string
    {
        return $this->attributes[$key] ?? null;
    }

    public function formatDimensions(): ?string
    {
        if (empty($this->dimensions)) {
            return null;
        }

        $parts = [];
        if (isset($this->dimensions['length'])) {
            $parts[] = $this->dimensions['length'];
        }
        if (isset($this->dimensions['width'])) {
            $parts[] = $this->dimensions['width'];
        }
        if (isset($this->dimensions['height'])) {
            $parts[] = $this->dimensions['height'];
        }

        return implode(' x ', $parts) . (isset($this->dimensions['unit']) ? ' ' . $this->dimensions['unit'] : '');
    }
}
