<?php

namespace Daylight\Connector2BA\Models;

use Illuminate\Database\Eloquent\Model;

class EtimClass extends Model
{
    protected $table = 'etim_classes';
    protected $primaryKey = 'code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'code',
        'name_en',
        'name_nl',
        'description_en',
        'description_nl',
        'sector',
        'version',
    ];

    public function features()
    {
        return $this->belongsToMany(EtimFeature::class, 'etim_class_feature', 'class_code', 'feature_code')
            ->withPivot('order_index', 'is_mandatory')
            ->withTimestamps();
    }
}
