<?php

namespace Daylight\Connector2BA\Models;

use Illuminate\Database\Eloquent\Model;

class EtimValue extends Model
{
    protected $table = 'etim_values';
    protected $primaryKey = 'code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'code',
        'feature_code',
        'label_en',
        'label_nl',
        'sort_index',
    ];

    public function feature()
    {
        return $this->belongsTo(EtimFeature::class, 'feature_code', 'code');
    }
}
