<?php

namespace Daylight\Connector2BA\Requests\Products;

use Daylight\Connector\Contracts\MapperInterface;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetProductRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected MapperInterface $mapper,
        protected readonly string $gtin
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        //return '/1/json/product/DetailsForProduct?gtin=' . $this->gtin . '&includeFeatures=true'; // By GTIN
        return '/1/json/product/DetailsByGLNAndProductcodeA?gln=8714253038889&productcode=131210100&includeCountryOfProduction=false';
    }

    protected function defaultQuery(): array
    {
        return [];
    }

    public function createDtoFromResponse(Response $response): mixed
    {
        $json = $response->json();

        dd($response->json());

        // Assuming 2BA returns products in a 'data' field
        $products = $json['data'] ?? $json;

        if (!is_array($products)) {
            return collect();
        }

        return collect($products)
            ->map(fn ($item) => $this->mapper->map($item));
    }
}

