<?php

namespace Daylight\Connector2BA\Requests\SelectionProfile;

use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class DownloadFilesRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected readonly string $selectionProfileId,
    ) {
    }

    public function resolveEndpoint(): string
    {
        return '/SelectionProfile/filesB';
    }

    protected function defaultQuery(): array
    {
        return [
            'id' => $this->selectionProfileId,
        ];
    }

    /**
     * Return the JSON response with download information
     */
    public function createDtoFromResponse(Response $response): mixed
    {
        // Return the JSON response containing download links
        return $response->json();
    }
}
