<?php

namespace Daylight\Connector2BA\Requests\SelectionProfile;

use Psr\Http\Message\RequestInterface;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;

class RequestDirectProfileRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function __construct(
        protected string $methodCode,                  // "SA_MF"
        protected string $format,                      // "PAB200"
        protected ?string $mutationsFrom = '',
        protected string $profileName = "HEG",
        protected bool $includeRefurbished = true,
        protected bool $includeUsed = true,
        protected bool $includeResidualmaterial = false,
        protected array $lines = [],                  // [['SupplierGLN'=>'...', 'TradeItemId'=>'...'], ...]
        protected string $apiVersion = '1',           // hoofdversie
        protected ?string $subVersion = null          // bv. '1' → /1/1/...
    ) {
    }

    public function resolveEndpoint(): string
    {
        return '/SelectionProfile/RequestDirectProfile';
    }

    protected function defaultBody(): array
    {
        return [
            'method' => $this->methodCode,
            'format' => $this->format,
            'mutationsFrom' => $this->mutationsFrom ?? '',
            'profileName' => $this->profileName,
            'includeRefurbished' => $this->includeRefurbished,
            'includeUsed' => $this->includeUsed,
            'includeResidualmaterial' => $this->includeResidualmaterial,
            'lines' => $this->lines,
        ];
//        return json_encode([
//            'lines' => $this->lines,
//        ]);
    }

    protected function defaultHeaders(): array
    {
        return [
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
        ];
    }

    /**
     * Return the JSON response with direct profile information
     */
    public function createDtoFromResponse(Response $response): mixed
    {
        return $response->json();
    }
}
