<?php

namespace Daylight\Connector2BA\Resources;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector2BA\Requests\Products\GetProductsRequest;
use Daylight\Connector2BA\Requests\Products\GetProductRequest;
use Saloon\Http\BaseResource;
use Saloon\Http\Response;

class Products extends BaseResource
{
    /**
     * Fetch all products.
     */
    public function all(MapperInterface $mapper, int $page = 1, int $limit = 10): Response
    {
        return $this->connector->send(
            new GetProductsRequest($mapper, $page, $limit)
        );
    }

    /**
     * Fetch a single product by its ID.
     */
    public function get(MapperInterface $mapper, string $gtin): Response
    {
         return $this->connector->send(
             new GetProductRequest($mapper, $gtin)
         );

        throw new \Exception('Single product fetch not implemented yet');
    }
}

