<?php

namespace Daylight\Connector2BA;

use Daylight\Connector2BA\Console\DownloadSelectionProfile;
use Daylight\Connector2BA\Console\GetDataByGTIN;
use Daylight\Connector2BA\Console\ImportAttachments;
use Daylight\Connector2BA\Console\ImportEtimData;
use Daylight\Connector2BA\Console\ProcessEtimData;
use Daylight\Connector2BA\Console\RequestDirectProfile;
use Daylight\Connector2BA\Console\Sync2baAttachmentsToVariants;
use Daylight\Connector2BA\Console\TestAuthentication;
use Illuminate\Support\ServiceProvider;

class DaylightConnector2BAServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        // Register console commands
        $this->commands([
            DownloadSelectionProfile::class,
            GetDataByGTIN::class,
            ImportAttachments::class,
            TestAuthentication::class,
            ImportEtimData::class,
            ProcessEtimData::class,
            RequestDirectProfile::class,
            Sync2baAttachmentsToVariants::class,
        ]);
    }

    public function boot(): void
    {
        // Load migrations
        $this->loadMigrationsFrom(__DIR__.'/../database/migrations');
    }
}
