<?php

namespace Daylight\Connector2BA\Resources;

use Daylight\Connector2BA\Requests\SelectionProfile\DeleteFileRequest;
use Daylight\Connector2BA\Requests\SelectionProfile\DownloadFilesRequest;
use Daylight\Connector2BA\Requests\SelectionProfile\RequestDirectProfileRequest;
use Saloon\Http\BaseResource;
use Saloon\Http\Response;

class SelectionProfile extends BaseResource
{
    /**
     * Download SelectionProfile files for a given ID.
     */
    public function downloadFiles(string $selectionProfileId): Response
    {
        return $this->connector->send(
            new DownloadFilesRequest($selectionProfileId)
        );
    }

    public function deleteFile(string $selectionProfileId): Response
    {
        return $this->connector->send(
            new DeleteFileRequest($selectionProfileId)
        );
    }

    /**
     * Request direct profile for specific lines/products.
     */
    public function requestDirectProfile(array $lines): Response
    {
        return $this->connector->send(
            new RequestDirectProfileRequest($lines)
        );
    }
}
