<?php

namespace Daylight\Connector2BA\Models;

use Illuminate\Database\Eloquent\Model;

class EtimFeature extends Model
{
    protected $table = 'etim_features';
    protected $primaryKey = 'code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'code',
        'name_en',
        'name_nl',
        'datatype',
        'unit_code',
        'description_en',
        'description_nl',
    ];

    public function values()
    {
        return $this->hasMany(EtimValue::class, 'feature_code', 'code');
    }

    public function unit()
    {
        return $this->belongsTo(EtimUnit::class, 'unit_code', 'code');
    }

    public function classes()
    {
        return $this->belongsToMany(EtimClass::class, 'etim_class_feature', 'feature_code', 'class_code')
            ->withPivot('order_index', 'is_mandatory')
            ->withTimestamps();
    }
}
