<?php

namespace Daylight\Connector2BA\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EtimClassFeature extends Pivot
{
    protected $table = 'etim_class_feature';

    protected $fillable = [
        'class_code',
        'feature_code',
        'order_index',
        'is_mandatory',
        'feature_type',
        'unit_code',
    ];

    /**
     * Get the ETIM class that this feature belongs to
     */
    public function etimClass(): BelongsTo
    {
        return $this->belongsTo(EtimClass::class, 'class_code', 'code');
    }

    /**
     * Get the ETIM feature information
     */
    public function etimFeature(): BelongsTo
    {
        return $this->belongsTo(EtimFeature::class, 'feature_code', 'code');
    }

    /**
     * Get the ETIM unit if this feature has one
     */
    public function etimUnit(): BelongsTo
    {
        return $this->belongsTo(EtimUnit::class, 'unit_code', 'code');
    }
}
