<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('variants', function (Blueprint $table) {
            $table->string('gln_manufacturer')->nullable()->after('order');
            $table->string('gtin_product')->nullable()->after('gln_manufacturer');
            $table->string('productcode_manufacturer')->nullable()->after('gtin_product');
            $table->string('type_manufacturer')->nullable()->after('productcode_manufacturer');
            $table->string('series')->nullable()->after('type_manufacturer');
            $table->string('unspsc_code')->nullable()->after('series');
            $table->dateTime('2ba_synced_at')->nullable()->after('unspsc_code');
        });
    }

    public function down(): void
    {
        Schema::table('variants', function (Blueprint $table) {
            $table->dropColumn('gln_manufacturer');
            $table->dropColumn('gtin_product');
            $table->dropColumn('productcode_manufacturer');
            $table->dropColumn('type_manufacturer');
            $table->dropColumn('series');
            $table->dropColumn('unspsc_code');
            $table->dropColumn('2ba_synced_at');
        });
    }
};
