<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('2ba_data', function (Blueprint $table) {
            $table->json('brand')->nullable()->after('brandName');
            $table->string('productName')->nullable()->after('productCode');
        });
    }

    public function down(): void
    {
        Schema::table('2ba_data', function (Blueprint $table) {
            $table->dropColumn('brand');
            $table->dropColumn('productName');
        });
    }
};
