<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('order_items', function (Blueprint $table) {
            $table->string('status')->default('pending')->after('variant_id');
            $table->integer('price_final')->nullable()->after('price');
            $table->integer('discount')->nullable()->after('price_final');
            $table->integer('tax')->nullable()->after('discount');
            $table->json('tax_breakdown')->nullable()->after('tax');
            $table->dateTime('delivery_date')->nullable()->after('tax_breakdown');
            $table->integer('seq')->default(1)->after('delivery_date');

        });
    }

    public function down(): void
    {
        Schema::table('order_items', function (Blueprint $table) {
            $table->dropColumn('status');
            $table->dropColumn('price_final');
            $table->dropColumn('tax');
            $table->dropColumn('tax_breakdown');
            $table->dropColumn('delivery_date');
            $table->dropColumn('seq');
        });
    }
};
