<?php

namespace Daylight\ConnectorCash\Enums;

enum ShippingMethod: string
{
    case PICKUP = 'pickup';

    case SHIPPING = 'shipping';

    public static function fromCode(string $code): ?self
    {
        return match($code) {
            'LEV' => self::PICKUP,
            default => self::SHIPPING,
        };
    }

    public function label(): string
    {
        return match ($this) {
            self::PICKUP => 'pickup',
            self::SHIPPING => 'shipping',
        };
    }
}
