<?php

namespace Daylight\ConnectorCash\Http;

use Daylight\Connector\Contracts\ConnectorInterface;
use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Services\BaseConnector;
use Daylight\Connector\Support\ConnectorLogger;
use Daylight\ConnectorCash\Mappers\OrderMapper;
use Daylight\ConnectorCash\Mappers\OrderItemMapper;
use Daylight\ConnectorCash\Mappers\ProductMapper;
use Daylight\ConnectorCash\Mappers\CustomerMapper;
use Daylight\ConnectorCash\Mappers\UserMapper;
use Daylight\ConnectorCash\Mappers\AddressMapper;
use Saloon\Http\Auth\BasicAuthenticator;
use Saloon\Http\Auth\TokenAuthenticator;
use Illuminate\Support\Str;
use Daylight\ConnectorCash\Middleware\EncryptResponse;

class Cash extends BaseConnector
{
    protected string $name = 'Visma Cash';
    protected string $namespace = 'Daylight\ConnectorCash';

    public function __construct()
    {
        // @todo is this necessary?
        parent::__construct(
            new ConnectorLogger()
        );
    }
    /**
     * Get the name of the connector.
     *
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    public function getKey(): string
    {
        return Str::slug($this->getName());
    }

    public function resolveBaseUrl(): string
    {
        return config('services.connector.cash.url');
    }

    public function defaultHeaders(): array
    {
        return [
            'Accept' => 'application/json',
            'Cache-Control' => 'no-cache',
            'Sec-Fetch-Mode' => 'cors',
            'Authorization' => config('services.connector.cash.api'),
        ];
    }

    public function getProductMapper(): MapperInterface
    {
        return new ProductMapper();
    }

    public function getCustomerMapper(): MapperInterface
    {
        return new CustomerMapper();
    }

    public function getUserMapper(): MapperInterface
    {
        return new UserMapper();
    }

    public function getOrderMapper(): MapperInterface
    {
        return new OrderMapper();
    }

    public function getOrderItemMapper(): MapperInterface
    {
        return new OrderItemMapper();
    }

    public function getAddressMapper(): MapperInterface
    {
        return new AddressMapper();
    }

    /**
     * Connector specific requestHandler, called by Connector Core
     *
     * @param string $request
     * @param MapperInterface $mapper
     * @param array $options
     * @return \Saloon\Http\Response
     * @throws \ErrorException
     * @throws \Saloon\Exceptions\Request\FatalRequestException
     * @throws \Saloon\Exceptions\Request\RequestException
     */
    public function requestHandler(string $request, MapperInterface $mapper, array $options = [])
    {
        if (!$request) {
            throw new \ErrorException('No request set.');
        }

        $class = $this->namespace."\\Requests\\".$request;

        if (!class_exists($class)) {
            throw new \ErrorException('No requestclass found: ' . $class);
        }

        return $this->send(
            new $class($mapper, $options)
        );
    }
}
