## Daylight Visma Cash Connector

### Config
The Daylight Visma Cash Connector is configured using the `config/services.php` file. Your .env file contains the necessary settings to connect to the Visma Cash API and manage the integration.

```
CONNECTOR_CASH_API=xxx
CONNECTOR_CASH_URL="https://www.cashweb.nl/api/4.0/"
CONNECTOR_CASH_ADMINISTRATION=tstt
```

```
'connector' => [
    'cash' => [
        'url' => env('CONNECTOR_CASH_URL'),
        'api' => env('CONNECTOR_CASH_API'),
        'administration' => env('CONNECTOR_CASH_ADMINISTRATION'),
    ],
],
```

### URL Encoding Fix

This connector includes a fix for URL encoding issues with the Cash API. The Cash API requires literal pipe characters (`|`) in endpoints, but Saloon automatically URL-encodes them to `%7C`, which breaks the API calls.

#### How it works

The fix is implemented using Saloon's `handlePsrRequest` method:
1. Intercepts PSR-7 requests before they're sent to the API
2. Checks the request path for URL-encoded pipes (`%7C`)
3. Replaces them with literal pipe characters (`|`)
4. Returns the modified request

#### Example

- **Original endpoint**: `/get/index/2260M|1003036791`
- **Saloon would encode to**: `/get/index/2260M%7C1003036791`
- **Our fix converts back to**: `/get/index/2260M|1003036791`

This ensures that the Cash API receives the endpoints in the format it expects, allowing proper communication with the external service.

