<?php

namespace Daylight\ConnectorCash\Entities;

use Carbon\Carbon;
use Daylight\Core\Models\Country;
use Daylight\Core\Models\TaxClass;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Date;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Data;
use Daylight\Connector\Entities\Address as BaseAddress;

class Address extends BaseAddress
{
    public function __construct(
        public string $external_id, //2228
        public int $customer_external_id, //0101
        public ?Carbon $created_at, //2306
        public ?string $name, //0103
        public string $address_line_1, //1833
        public string $address_line_2, //1834
        public string $postal_code, //0438
        public string $city, //1837
        public string $county_code, //0130
        public string $type,
    )
    {
        //
    }

    public function getCountryCode()
    {
        return Country::whereCode($this->county_code)->firstOrFail();
    }
}
