<?php

namespace Daylight\ConnectorCash\Entities;

use Carbon\Carbon;
use Daylight\Core\Models\TaxClass;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Date;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Data;
use Daylight\Connector\Entities\OrderItem as BaseOrderItem;

class OrderItem extends BaseOrderItem
{
    public function __construct(
        public string $external_id, // 2400
        public float $discount, //2002
        public string $sku, //2260
        public float $sale_price, //2267
        public float $lineTotal, //2421
        public string $discount_code, //2268
        public ?Carbon $delivery_date, //2402
        public float $quantity, //2410 / 100
        public int $line_seq, //2426
        public int $seq, //3325
        public string $status, //2404
    )
    {
        //
    }
}
