<?php

namespace Daylight\ConnectorCash\Enums;

/**
 * @todo: implement paymentmethod cash (kontant) and pin (card) in the core
 */
enum PaymentMethod: string
{
    case INVOICE = 'invoice';

    case CASH_ON_DELIVERY = 'cash_on_delivery';

    case CASH = 'cash';

    case CARD = 'card';

    case IDEAL = 'ideal';

    public static function fromId(int $id): ?self
    {
        return match($id) {
            0, 1, 10, 12, 4, 41, 5, 6, 65, 66, 7, 8, 9, 91, 92 => self::INVOICE,
            13 => self::IDEAL,
//            13 => self::CASH,
            default => null,
        };
    }

    public function label(): string
    {
        return match($this) {
            self::INVOICE => 'invoice',
            self::CASH_ON_DELIVERY => 'cash_on_delivery',
            self::CASH => 'cash',
            self::CARD => 'card',
            self::IDEAL => 'ideal',
        };
    }
}
