<?php

namespace Daylight\ConnectorCash\Requests\Addresses;

use Illuminate\Support\Arr;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;
use Illuminate\Support\Facades\Log;

class GetAddressesRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected MapperInterface $mapper,
        protected array $options = [],
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/get/index/2229';
    }

    protected function defaultQuery(): array
    {
        return [
            'admin' => config('services.connector.cash.administration'),
        ];
    }

    public function createDtoFromResponse(Response $response): mixed
    {
        $json = json_decode($response, true);

        $raw = data_get($json, 'R2229');
        if (is_array($raw) && ! Arr::isAssoc($raw)) {
            $items = $raw;
        } elseif (is_null($raw)) {
            $items = [];
        } else {
            $items = [$raw];
        }

        return collect($items)
            ->map(fn ($item) => $this->mapper->map($item))
            ->values();
    }
}
