<?php

namespace Daylight\ConnectorCash\Entities;

use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Data;
use Daylight\Connector\Entities\Customer as BaseCustomer;
use Daylight\Core\Models\Country;

class Customer extends BaseCustomer
{
    public function __construct(
        public int $external_id,
        public string $email,
        public ?string $invoiceEmail,
        public string $name,
        public ?string $address,
        public ?string $zipCity,
        public ?string $country,
        public string $creditRestriction,
        public ?string $shippingAddress,
        public ?string $shippingZipCity,
        public ?string $is_webshop,
        public ?string $price_code,
    )
    {
        //
    }

    public function splitBillingZipCity(): array
    {
        if (preg_match('/^(\d{4}\s?[A-Z]{2})\s+(.*)$/', trim($this->zipCity), $matches)) {
            $zipcode = $matches[1];
            $city = $matches[2];
        } else {
            $zipcode = '';
            $city = '';
        }

        return [$zipcode, $city];
    }

    public function splitShippingZipCity(): array
    {
        if (preg_match('/^(\d{4}\s?[A-Z]{2})\s+(.*)$/', trim($this->shippingZipCity), $matches)) {
            $zipcode = $matches[1];
            $city = $matches[2];
        } else {
            $zipcode = '';
            $city = '';
        }

        return [$zipcode, $city];
    }

    public function getCountryCode()
    {
        return Country::whereCode($this->country)->firstOrFail();
    }
}
