<?php

namespace Daylight\ConnectorCash\Entities;

use Carbon\Carbon;
use Daylight\Core\Models\TaxClass;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Date;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Data;
use Daylight\Connector\Entities\Order as BaseOrder;

class Order extends BaseOrder
{
    public function __construct(
        public string $external_id, // 2400
        public int $customer_external_id, //2220
        public ?Carbon $order_date, //2401
        public ?Carbon $delivery_date, //2402
        public string $shipping, //2210
        public ?string $status, //2404
        public ?int $seq, //2424
        public ?Carbon $packingslip_date, //2430
        public ?string $reference, //2406
        public ?string $payment_condition, //2212
        public ?string $usernumber, //2237
        public ?int $deliveryAddress, //F2419
        public ?Collection $items,
    )
    {
        //
    }
}
