<?php

namespace Daylight\ConnectorCash\Listeners;

use Daylight\Connector\Registries\ConnectorRegistry;
use Daylight\Connector\Services\BaseConnector;
use Daylight\ConnectorCash\Http\Cash;
use Daylight\ConnectorCash\Requests\Users\GetUserNextRelationNumber;
use Illuminate\Auth\Events\Registered;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Daylight\ConnectorCash\Requests\Users\PostUserRequest;
use Daylight\ConnectorCash\Requests\Customers\PostCustomerRequest;
use Illuminate\Support\Facades\Log;
//implements ShouldQueue
class RegisterUser
{
    public function __construct(
    ) {
        //
    }

    public function handle(Registered $event)
    {
        $user = $event->user;

        $connector = new Cash();

        if (!$connector) {
            Log::error('No active connector found.');
            return;
        }

        // Get the new next relationnumber out of Cash
        $request = new GetUserNextRelationNumber();
        $number = $connector->send($request);

        if ($number->status() !== 200) {
            Log::error('GetUserNextRelationNumber failed.');
            return;
        }

        $relationNumber = data_get($number->json(), 'R2050.Z0101') ?? null;
        if (empty($relationNumber)) {
            Log::error('RelationNumber empty.');
            return;
        }

        Log::info('New relation: ' . $relationNumber);

        $customerRequest = new PostCustomerRequest($user, $relationNumber);
        $relation = $connector->send($customerRequest);

        if ($relation->failed()) {
            Log::error('PostCustomerRequest failed.', [
                'message' => $relation->json() ?? $relation->body()?->getContents() ?? 'No response body',
                'status' => $relation->status(),
            ]);
            return;
        }

        // Update the customer
        $user->customer->update(
            [
                'external_id' => $relationNumber,
                'active' => 1,
            ]
        );

        $userRequest = new PostUserRequest($user, $relationNumber);
        $userRelation = $connector->send($userRequest);

        Log::debug('New user created', ['body' => $userRelation->json()]);

        if ($userRelation->failed()) {
            Log::error('PostCustomerRequest failed.', [
                'message' => $userRelation->json() ?? $userRelation->body()?->getContents() ?? 'No response body',
                'status' => $userRelation->status(),
            ]);
            return;
        }

        // Update the user
        $user->update(
            [
                'number' => '001',
            ]
        );

        return;
    }

//    private function getConnector(Collection $connectors, string $connectorKey): null|BaseConnector|Cash
//    {
//        if ($connectors[$connectorKey]) {
//            $class = $connectors[$connectorKey]->connector;
//
//            return new $class;
//        }
//
//        return null;
//    }
}
