<?php

namespace Daylight\ConnectorCash\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Core\Models\Customer;
use Daylight\ConnectorCash\Entities\Customer as CustomerEntity;

class CustomerMapper implements MapperInterface
{
    /**
     * Map the data to the format required by the connector.
     *
     * @param array $data
     * @return array
     */
    public function map(array $data): CustomerEntity
    {
        return new CustomerEntity(
            (int)$data['F0101'],
            $data['F0120'] ?? $data['F0132'] ?? $data['F0131'] ?? '-', //
            $data['F0131'] ?? null,
            $data['F0103'] ?? '',
            $data['F0105'] ?? null,
            $data['F0107'] ?? null,
            $data['F0130'] ?? 'NL',
            $data['F0121'] ?? 'N', // D optional (value L = J at systemvariable, J always, N never)
            $data['F0123'] ?? null,
            $data['F0124'] ?? null,
            $data['F1655'] ?? 'N', // (J = webshop active, N or not set = not webshop active)
            $data['F0113'] ?? '',
        );
    }

    public function mapWithAttributes(array $data, array $attributes = []): CustomerEntity
    {
        $product = $this->map($data);
        foreach ($attributes as $key => $value) {
            $product->{$key} = $value;
        }
        return $product;
    }
}
