<?php

namespace Daylight\ConnectorCash\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Core\Models\Customer;
use Daylight\ConnectorCash\Entities\PriceList as PriceListEntity;
use Illuminate\Support\Facades\Date;
use Carbon\Carbon;
use Daylight\ConnectorCash\Enums\PaymentMethod;
use Daylight\ConnectorCash\Enums\ShippingMethod;
use Daylight\ConnectorCash\Enums\OrderStatus;

class PriceListMapper implements MapperInterface
{
    /**
     * Map the data to the format required by the connector.
     *
     * @param array $data
     * @return array
     */
    public function map(array $data): PriceListEntity
    {
        return new PriceListEntity(
            isset($data['F2002']) ? (float)$data['F2002'] : 0,
            isset($data['F2200']) ? $data['F2200'] : '',
            isset($data['F2208']) ? $data['F2208'] : 0,
            isset($data['F2306']) ? Carbon::createFromFormat('d-m-Y', $data['F2306']) : null,
        );
    }

    public function mapWithAttributes(array $data, array $attributes = []): PriceListEntity
    {
        $product = $this->map($data);
        foreach ($attributes as $key => $value) {
            $product->{$key} = $value;
        }
        return $product;
    }
}
