<?php

namespace Daylight\ConnectorCash\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\ConnectorCash\Entities\User as UserEntity;

class UserMapper implements MapperInterface
{
    /**
     * Map the data to the format required by the connector.
     *
     * @param array $data
     * @return array
     */
    public function map(array $data): UserEntity
    {
        return new UserEntity(
            null,
            (int)$data['F0101'] ?? null,
            $data['F0103'] ?? '-',
            $data['F0120'] ?? null,
            $data['F0108'] ?? $data['F0144'] ?? null,
            $data['F0140'] ?? '001',
        );
    }

    public function mapWithAttributes(array $data, array $attributes = []): UserEntity
    {
        $product = $this->map($data);
        foreach ($attributes as $key => $value) {
            $product->{$key} = $value;
        }
        return $product;
    }
}
