<?php

namespace Daylight\ConnectorCash\Entities;

use Daylight\Core\Models\TaxClass;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Data;

class Stock extends Data
{
    public function __construct(
        public string $sku, //2260
        public int $quantity, //2273
        public int $decimals //2294
    )
    {
        //
    }

    public function formatQuantity()
    {
        switch($this->decimals) {
            case 0:
                $q = $this->quantity;
                break;
            case 1:
                $q = ($this->quantity/10);
                break;
            case 2:
                $q = ($this->quantity/100);
                break;
            case 3:
                $q = ($this->quantity/1000);
                break;
            case 4:
                $q = ($this->quantity/10000);
                break;
            case 5:
                $q = ($this->quantity/100000);
                break;
            default:
                $q = $this->quantity;
        }
        return round($q);
    }
}
