<?php

namespace Daylight\ConnectorCash\Jobs;

use App\Models\User;
use Daylight\Core\Models\Customer;
use Daylight\ConnectorCash\Entities\PriceAgreement as PriceAgreementEntity;
use Daylight\Core\Models\Variant;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Str;
use Daylight\Core\Models\Enums\CustomerType;
use Daylight\Core\Models\Enums\AddressType;
use Illuminate\Support\Facades\Log;

class UpdatePriceAgreement implements ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public PriceAgreementEntity $priceAgreement,
    )
    {
        //
    }

    public function handle(): void
    {
        if (
            (!$this->priceAgreement->sku && $this->priceAgreement->sku == 0)
            || $this->priceAgreement->discount == 'N'
            || $this->priceAgreement->price == 0
        ) {
            return;
        }

        $variant = daylightModel('variant')::where('sku', $this->priceAgreement->sku)->first();
        $customer_id = self::getCustomerId($this->priceAgreement->customer_external_id);

        if (!$variant || !$customer_id) {
            return;
        }

        $variant
            ->prices()
            ->updateOrCreate(
                [
                    'customer_group_id' => null,
                    'customer_id' => $customer_id,
                    'starts_at' => $this->priceAgreement->date,
                    'ends_at' => null,
                ],
                [
                    'price' => $this->priceAgreement->price,
                ]
            );
    }

    private function getCustomerId(int $external_id): ?int
    {
        $customer = daylightModel('customer')::where('external_id', $external_id)->first();
        return $customer ? $customer->id : null;
    }
}
