<?php

namespace Daylight\ConnectorCash\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Core\Models\Customer;
use Daylight\ConnectorCash\Entities\PriceAgreement as PriceAgreementEntity;
use Illuminate\Support\Facades\Date;
use Carbon\Carbon;
use Daylight\ConnectorCash\Enums\PaymentMethod;
use Daylight\ConnectorCash\Enums\ShippingMethod;
use Daylight\ConnectorCash\Enums\OrderStatus;

class PriceAgreementMapper implements MapperInterface
{
    /**
     * Map the data to the format required by the connector.
     *
     * @param array $data
     * @return array
     */
    public function map(array $data): PriceAgreementEntity
    {
        return new PriceAgreementEntity(
            isset($data['F2260']) ? (int)$data['F2260'] : 0,
            isset($data['F2268']) ? strtoupper($data['F2268']) : 'N', // B -> bruto price, so this is a discount. N -> netto, no discount for the user
            isset($data['F2220']) ? $data['F2220'] : 0,
            isset($data['F2267']) ? (float)$data['F2267'] : 0,
            isset($data['F2306']) ? Carbon::createFromFormat('d-m-Y', $data['F2306']) : null,
        );
    }

    public function mapWithAttributes(array $data, array $attributes = []): PriceAgreementEntity
    {
        $product = $this->map($data);
        foreach ($attributes as $key => $value) {
            $product->{$key} = $value;
        }
        return $product;
    }
}
