<?php

namespace Daylight\ConnectorCash\Requests\Products;

use Daylight\ConnectorCash\CustomUriGenerator;
use Daylight\ConnectorCash\Entities\Product;
use GuzzleHttp\Psr7\Uri;
use Psr\Http\Message\RequestInterface;
use Saloon\Enums\Method;
use Saloon\Http\PendingRequest;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;
use Illuminate\Support\Facades\Log;
use Saloon\Helpers\URLHelper;
use Illuminate\Support\Arr;

class GetProductsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected MapperInterface $mapper,
        protected array $options,
    ) {
        //
    }

    public function handlePsrRequest(RequestInterface $request, PendingRequest $pendingRequest): RequestInterface
    {
        $url = new CustomUriGenerator($request->getUri());
        $newRequest = $request->withUri(
            $url
        );

        return $newRequest;
    }

    public function resolveEndpoint(): string
    {
        if (isset($this->options['migrations']) && $this->options['migrations'] === true) {
            return (isset($this->options['pageNumber']) && $this->options['pageNumber'] > 1)
                ? "/get/index/2260W|{$this->options['pageNumber']}"
                : "/get/index/2260W&params=2";
        }
        return (isset($this->options['pageNumber']) && $this->options['pageNumber'] > 1)
            ? "/get/index/2260M|{$this->options['pageNumber']}"
            : "/get/index/2260M";
    }

    protected function defaultQuery(): array
    {
        return [
            'admin' => config('services.connector.cash.administration'),
        ];
    }

    public function createDtoFromResponse(Response $response): mixed
    {
        $json = json_decode($response, true);

        $raw = data_get($json, 'R2260');
        if (is_array($raw) && ! Arr::isAssoc($raw)) {
            $items = $raw;
        } elseif (is_null($raw)) {
            $items = [];
        } else {
            $items = [$raw];
        }

        $collection = collect($items)
            ->map(fn ($item) => $this->mapper->map($item))
            ->values();

        // Check if this is the last batch AFTER processing the items
        if (data_get($json, 'End') === 'Done') {
            throw new \Daylight\ConnectorCash\Exceptions\EndOfResultsException(
                'End of results reached',
                $collection
            );
        }

        return $collection;
    }
}
