<?php

namespace Daylight\ConnectorCash\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\ConnectorCash\Entities\Product as ProductEntity;

class StockMapper implements MapperInterface
{
    /**
     * Map the data to the format required by the connector.
     *
     * @param array $data
     * @return array
     */
    public function map(array $data): ProductEntity
    {
        return new ProductEntity(
            $data['F2260'],
            $data['F2348'] ?? null,
            $data['F2001'] ?? 'no-title',
            '',
            $data['F2208'] ?? '',
            $data['F2202'] ?? '', //KST = kortenartikel, UITL = uitlopen (bij geen voorraad niet meer verkoopbaar), BLOK = geblokkeerd, niet verkopen
            $data['F2230'] ?? '',
            $data['F2261'] ?? '',
            $data['F2263'] ?? '',
            $data['F2264'] ?? '',
            (float)($data['F2266'] ?? 0),
            (float)($data['F2267'] ?? 0),
            $data['F2268'] ?? 'B', //N -> no discount possible
            $data['F2280'] ?? 'N', //J = blocked
            (float)($data['F2282'] ?? 0),
            $data['F2285'] ?? 'ST.',
            $data['F2295'] ?? 'A', //only handle A (and K)
            (int)($data['F2274'] ?? 1),
            (int)($data['F2383'] ?? 1),
            $data['F2456'] ?? 'H', //Hoog, Laag, Overig tarief, Nultarief, Onbelast
            (int)($data['F2293'] ?? 0),
            (int)($data['F2294'] ?? 2)
        );
    }

    public function mapWithAttributes(array $data, array $attributes = []): ProductEntity
    {
        $product = $this->map($data);
        foreach ($attributes as $key => $value) {
            $product->{$key} = $value;
        }
        return $product;
    }
}
