<?php

namespace Daylight\ConnectorCash\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\ConnectorCash\Entities\Address as AddressEntity;
use Illuminate\Support\Facades\Date;
use Carbon\Carbon;
use Daylight\ConnectorCash\Enums\OrderStatus;
use NumberFormatter;

class AddressMapper implements MapperInterface
{
    /**
     * Map the data to the format required by the connector.
     *
     * @param array $data
     * @return array
     */
    public function map(array $data): AddressEntity
    {
        return new AddressEntity(
            $data['F2228'],
            isset($data['F0101']) ? $data['F0101'] : 0,
            isset($data['F2306']) ? Carbon::createFromFormat('d-m-Y', $data['F2306']) : null,
            isset($data['F0103']) ? $data['F0103'] : '',
            $data['F1833'],
            $data['F1834'],
            $data['F0438'],
            $data['F1837'],
            $data['F0130'],
            'shipping'
        );
    }

    public function mapWithAttributes(array $data, array $attributes = []): AddressEntity
    {
        $address = $this->map($data);
        foreach ($attributes as $key => $value) {
            $address->{$key} = $value;
        }
        return $address;
    }
}
