<?php

namespace Daylight\ConnectorCash\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Core\Models\Customer;
use Daylight\ConnectorCash\Entities\Order as OrderEntity;
use Illuminate\Support\Facades\Date;
use Carbon\Carbon;
use Daylight\ConnectorCash\Enums\PaymentMethod;
use Daylight\ConnectorCash\Enums\ShippingMethod;
use Daylight\ConnectorCash\Enums\OrderStatus;

class OrderMapper implements MapperInterface
{
    /**
     * Map the data to the format required by the connector.
     *
     * @param array $data
     * @return array
     */
    public function map(array $data): OrderEntity
    {
        return new OrderEntity(
            $data['F2400'] ?? null,
            (int)$data['F2220'] ?? null,
            isset($data['F2401']) ? Carbon::createFromFormat('d-m-Y', $data['F2401']) : null,
            isset($data['F2402']) ? Carbon::createFromFormat('d-m-Y', $data['F2402']) : null,
            ShippingMethod::fromCode($data['F2210'] ?? 'BEZ')?->label(),
            OrderStatus::fromCode($data['F2404'] ?? 'L')?->label(), //L = lopende order, V = verzamelbon, G = gereedgemelde verkooporder, B Verkooporderbevestiging afgedrukt, M Magazijnbon afgedrukt, P Pakbon afgedrukt, F Factureerbaar gestelde verkooporder
            (int)($data['F2424'] ?? 1),
            isset($data['F2430']) ? Carbon::createFromFormat('d-m-Y', $data['F2430']) : null,
            $data['F2406'] ?? null,
            PaymentMethod::fromId($data['F2212'] ?? 0)?->label(),
            isset($data['F2237']) ? $data['F2237'] : null,
            isset($data['F2419']) ? $data['F2419'] : null,
            null
        );
    }

    public function mapWithAttributes(array $data, array $attributes = []): OrderEntity
    {
        $product = $this->map($data);
        foreach ($attributes as $key => $value) {
            $product->{$key} = $value;
        }
        return $product;
    }
}
