<?php

namespace Daylight\ConnectorCash\Requests\Customers;

use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;
use Illuminate\Support\Facades\Log;

class GetCustomersRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected MapperInterface $mapper,
        protected array $options = [],
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/get/index/101';
    }

    protected function defaultQuery(): array
    {
        return [
            'admin' => config('services.connector.cash.administration'),
        ];
    }

    public function createDtoFromResponse(Response $response): mixed
    {
        $json = json_decode($response, true);

        return collect($json['R0101'])
            ->map(fn ($item) => $this->mapper->map(
                $item
            ));
    }
}
