<?php

namespace Daylight\ConnectorCash\Enums;

enum OrderStatus: string
{
    case PROCESSING = 'processing';

    case COMPLETED = 'completed';

    case CANCELLED = 'cancelled';

    case REFUNDED = 'refunded';

    case FAILED = 'failed';

    case PENDING = 'pending';

    case ON_HOLD = 'on_hold';

    case AWAITING_PAYMENT = 'awaiting_payment';

    public static function fromCode(string $code): ?self
    {
        return match($code) {
            'G', 'F' => self::COMPLETED,
            default => self::PROCESSING,
        };
    }

    public function label(): string
    {
        return match ($this) {
            self::PROCESSING => 'processing',
            self::COMPLETED => 'completed',
            self::CANCELLED => 'cancelled',
            self::REFUNDED => 'refunded',
            self::FAILED => 'failed',
            self::PENDING => 'pending',
            self::ON_HOLD => 'on_hold',
            self::AWAITING_PAYMENT => 'awaiting_payment',
        };
    }
}
