<?php

namespace Daylight\ConnectorCash\Jobs;

use App\Models\User;
use Daylight\Core\Models\Customer;
use Daylight\ConnectorCash\Entities\Address as AddressEntity;
use Daylight\Core\Models\Variant;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Str;
use Daylight\Core\Models\Enums\CustomerType;
use Daylight\Core\Models\Enums\AddressType;
use Illuminate\Support\Facades\Log;

class UpdateAddress implements ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public AddressEntity $address,
    ) {
        //
    }

    public function handle(): ?string
    {
        if (!$this->address->external_id || !$this->address->customer_external_id) {
            Log::error('Cannot create address');
            return false;
        }

        $customer = Customer::query()
            ->where('external_id', $this->address->customer_external_id)
            ->first();

        if (!$customer) {
            Log::error('Customer not found');
            return false;
        }

        $customer->addresses()->updateOrCreate([
            'type' => AddressType::SHIPPING->value,
            'external_id' => $this->address->external_id,
        ], [
            'name' => $this->address->name,
            'address_line_1' => $this->address->address_line_1,
            'address_line_2' => $this->address->address_line_2,
            'postal_code' => $this->address->postal_code,
            'city' => $this->address->city,
            'country_id' =>  $this->address->getCountryCode()->id ?? 26,
            'created_at' => $this->address->created_at,
        ]);

        return $customer->id;
    }
}
