<?php

namespace Daylight\ConnectorCash\Jobs;

use App\Models\User;
use Daylight\Core\Models\Customer;
use Daylight\ConnectorCash\Entities\User as UserEntity;
use Daylight\Core\Models\Variant;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Str;
use Daylight\Core\Models\Enums\CustomerType;
use Daylight\Core\Models\Enums\AddressType;
use Illuminate\Support\Facades\Log;

class UpdateUser implements ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public UserEntity $user,
    ) {
        //
    }

    public function handle(): ?string
    {

        if (!$this->user->customer_external_id || !$this->user->email || !filter_var($this->user->email, FILTER_VALIDATE_EMAIL)) {
            Log::error('Cannot create user: ', [$this->user->external_id, $this->user->email]);
            return false;
        }
        
        $customer = Customer::query()
            ->where('external_id', $this->user->customer_external_id)
            ->first();

        if (!$customer) {
            Log::error('Cannot find customer: ', [$this->user->customer_external_id]);
            return false;
        }

        $user = User::query()
            ->whereEmail($this->user->email)
            ->whereCustomerId($customer->id)
            ->first();

        if (!$user) {
            $customer->users()->create([
                'number' => $this->user->usernumber,
                'name' => $this->user->name ?? '-',
                'email' => $this->user->email,
                'phone' => $this->user->phone,
                'locale' => 'nl',
//                'email_verified_at' => now(),
                'password' => bcrypt(Str::password()),
                'invite_token' => Str::random(32),
            ]);

//            if (config('settings.general.send_invite_emails')) {
//                $user->sendInviteNotification();
//            }
        } else {
            $user->update([
                'number' => $this->user->usernumber,
                'name' => $this->user->name ?? '-',
                'email' => $this->user->email,
                'phone' => $this->user->phone,
            ]);
        }

        return $user?->id;
    }
}
