<?php

namespace Daylight\ConnectorCash\Requests\Orders;

use Daylight\ConnectorCash\CustomUriGenerator;
use Daylight\ConnectorCash\Entities\OrderItem;
use GuzzleHttp\Psr7\Uri;
use Illuminate\Support\Arr;
use Psr\Http\Message\RequestInterface;
use Saloon\Enums\Method;
use Saloon\Http\PendingRequest;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;

class GetOrderItemsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected MapperInterface $mapper,
        protected readonly array $options
    ) {
        //
    }

    public function handlePsrRequest(RequestInterface $request, PendingRequest $pendingRequest): RequestInterface
    {
        $url = new CustomUriGenerator($request->getUri());
        $newRequest = $request->withUri(
            $url
        );

        return $newRequest;
    }

    public function resolveEndpoint(): string
    {
        return '/get/index/2410|' . $this->options['orderNumber'];
    }

    protected function defaultQuery(): array
    {
        return [
            'admin' => config('services.connector.cash.administration'),
        ];
    }

    public function createDtoFromResponse(Response $response): mixed
    {
        $json = json_decode($response, true);

        $raw = data_get($json, 'R2410');
        if (is_array($raw) && ! Arr::isAssoc($raw)) {
            $items = $raw;
        } elseif (is_null($raw)) {
            $items = [];
        } else {
            $items = [$raw];
        }

        return collect($items)
            ->map(fn ($item) => $this->mapper->map($item))
            ->values();
    }
}
