<?php

namespace Daylight\ConnectorCash\Requests\Users;

use Daylight\ConnectorCash\Entities\User as UserEntity;
use Illuminate\Support\Arr;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;
use Illuminate\Support\Facades\Log;

class GetUserNextRelationNumber extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected array $options = [],
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/get/index/2050R';
    }

    protected function defaultQuery(): array
    {
        return [
            'admin' => config('services.connector.cash.administration'),
        ];
    }

    public function createDtoFromResponse(Response $response): mixed
    {
        return json_decode($response, true);
    }
}
