<?php

namespace Daylight\ConnectorCash\Requests\Users;

use Daylight\ConnectorCash\Entities\User as UserEntity;
use Daylight\Core\Services\Countries;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Contracts\Body\HasBody;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Carbon;
use Saloon\Traits\Body\HasJsonBody;
use App\Models\User;

class PostUserRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function __construct(
        protected User $user,
        protected ?int $relationNumber
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/import';
    }

    public function defaultBody(): array
    {
        $billingAddress = $this->user->customer->billingAddresses->first();

        return [
            'admin' => config('services.connector.cash.administration'),
            'format' => 0,
            'content' => [
                'cash' => [
                    [
                        'R105' => [
                            [
                                'F0101' => (string) $this->relationNumber,
                                'F0103' => $this->user->name . ' ' . $this->user->last_name,
                                'F105' => $billingAddress?->address_line_1 ?? '',
                                'F107' => ($billingAddress?->postal_code . ' ' . $billingAddress?->city) ?? '',
                                'F120' => $this->user->email,
                                'F108' => $this->user->phone,
                                'F125' => Countries::all()->firstWhere('id', $billingAddress?->country_id)?->code ?? 'NL',
                                'F478' => 'Webshop heg.nl ' . Carbon::now()->format('d-m-Y H:i:s'),
                                'F0140' => '001'
                                //'F133' => 'GEBLOKKEERD WEB',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }
}
