<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->integer('external_id')->nullable()->after('user_id');
            $table->dateTime('delivery_date')->nullable()->after('tax_breakdown');
            $table->string('source', 10)->default('webshop')->after('notes');
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('external_id');
            $table->dropColumn('delivery_date');
            $table->dropColumn('source');
        });
    }
};
