<?php

namespace Daylight\ConnectorCash;

use Daylight\Connector\Connector;
use Daylight\ConnectorCash\Console\UpdateOrders;
use Daylight\ConnectorCash\Console\UpdateProducts;
use Daylight\ConnectorCash\Console\UpdateCustomers;
use Daylight\Connector\Registries\ConnectorRegistry;
use Daylight\ConnectorCash\Console\UpdateUsers;
use Daylight\ConnectorCash\Console\UpdateAddresses;
use Daylight\Core\Modules\MenuBuilder\Menu;
use Daylight\Core\Modules\MenuBuilder\Registries\MenuRegistry;
use Illuminate\Support\ServiceProvider;
use Daylight\DaylightCore\Console\InstallCommand;
use Illuminate\Routing\Router;
use Spatie\ResponseCache\Middlewares\CacheResponse;
use Spatie\ResponseCache\Middlewares\DoNotCacheResponse;
use Illuminate\Support\Facades\Blade;
use Daylight\ConnectorCash\Http\Cash;
use Daylight\Connector\Contracts\AuthenticatorInterface;
use Daylight\ConnectorCash\Http\ConnectorLogger;

class DaylightConnectorCashServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->commands([
            UpdateProducts::class,
            UpdateCustomers::class,
            UpdateOrders::class,
            UpdateUsers::class,
            UpdateAddresses::class,
        ]);

        $this->loadMigrationsFrom(__DIR__.'/../database/migrations');
    }

    public function boot()
    {
        ConnectorRegistry::addConnector(
            Connector::create()
                ->setKey('cash')
                ->setConnector(Cash::class)
                ->setCommands([
                    [
                        'command' => UpdateProducts::class,
                        'schedule' => '0 0 * * *', // Daily at midnight
                        'priority' => 100,
                    ],
                    [
                        'command' => UpdateCustomers::class,
                        'schedule' => '0 0 * * *', // Daily at midnight
                        'priority' => 100,
                    ],
                    [
                        'command' => UpdateUsers::class,
                        'schedule' => '0 0 * * *', // Daily at midnight
                        'priority' => 100,
                    ],
                    [
                        'command' => UpdateOrders::class,
                        'schedule' => '0 0 * * *', // Daily at midnight
                        'priority' => 100,
                    ],
                    [
                        'command' => UpdateAddresses::class,
                        'schedule' => '0 0 * * *', // Daily at midnight
                        'priority' => 100,
                    ]
                ])

        );
    }
}
