<?php

namespace Daylight\ConnectorCash\Requests\Products;

use Daylight\ConnectorCash\CustomUriGenerator;
use Daylight\ConnectorCash\Entities\Product;
use GuzzleHttp\Psr7\Uri;
use Psr\Http\Message\RequestInterface;
use Saloon\Enums\Method;
use Saloon\Http\PendingRequest;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Daylight\Connector\Contracts\MapperInterface;
use Illuminate\Support\Facades\Log;
use Saloon\Helpers\URLHelper;

class GetProductsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected MapperInterface $mapper,
        protected array $options,
    ) {
        //
    }

    public function handlePsrRequest(RequestInterface $request, PendingRequest $pendingRequest): RequestInterface
    {
        $url = new CustomUriGenerator($request->getUri());
        $newRequest = $request->withUri(
            $url
        );

        return $newRequest;
    }

    public function resolveEndpoint(): string
    {
        return (isset($this->options['pageNumber']) && $this->options['pageNumber'] > 1)
            ? "/get/index/2260M|{$this->options['pageNumber']}"
            : "/get/index/2260M";
    }

    protected function defaultQuery(): array
    {
        return [
            'admin' => config('services.connector.cash.administration'),
//            'params' => '100110003'
        ];
    }

    public function createDtoFromResponse(Response $response): mixed
    {
        $json = $response->json();

        return collect($json['R2260'])
            ->map(fn ($item) => $this->mapper->map(
                $item
            ));
    }
}
