<?php

namespace Daylight\ConnectorCash\Entities;

use Daylight\Core\Models\TaxClass;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Data;
use Daylight\Connector\Entities\Product as BaseProduct;

class Product extends BaseProduct
{
    public function __construct(
        public string $sku,
        public ?string $ean,
        public string $title,
        public string $description,
        public string $articlegroup,
        public string $brand_nr,
        public string $search_name,
        public string $order_code,
        public string $order_amount,
        public float $purchase_price,
        public float $sale_price,
        public string $discount_code,
        public string $active,
        public float $fixed_transfer_price,
        public string $package_unit,
        public string $article_type,
        public string $sold_per,
        public int $price_per,
        public string $vat_code,
        public int $quantity,
        public int $decimals
    )
    {
        //
    }

    public function formatQuantity()
    {
        switch($this->decimals) {
            case 0:
                $q = $this->quantity;
                break;
            case 1:
                $q = ($this->quantity/10);
                break;
            case 2:
                $q = ($this->quantity/100);
                break;
            case 3:
                $q = ($this->quantity/1000);
                break;
            case 4:
                $q = ($this->quantity/10000);
                break;
            case 5:
                $q = ($this->quantity/100000);
                break;
            default:
                $q = $this->quantity;
        }
        return round($q);
    }

    public function formatStatus(): int {
        if ($this->active === 'N') {
            return 2;
        }

        return 0;
    }

    public function getTaxClass(): int
    {
        switch($this->vat_code) {
            case 'H':
                return 1;
                break;
            case 'L':
                return 2;
                break;
            case 'N':
            case 'O':
                return 3;
                break;
            default:
                return 1;
        }
    }

    public function canBePurchased(): bool
    {
        return true;
    }
}
