<?php

namespace Daylight\Connector\Contracts;

/**
 * Interface MapperInterface
 * @package Daylight\Connector\Contracts
 *
 * A mapper is responsible for mapping data from one format to another.
 */
interface MapperInterface
{
    /**
     * Map the given data to a model or entity.
     * Return type is mixed so it is as flexible as possible.
     *
     * @param array $data
     * @return mixed
     */
    public function map(array $data): mixed;

    /**
     * Map the given data to a model or entityt with additional attributes.
     * Return type is mixed so it is as flexible as possible.
     *
     * @param array $data
     * @param array $attributes
     * @return mixed
     */
    public function mapWithAttributes(array $data, array $attributes = []): mixed;
}
